function GibbsSummary(s,drop,vNames,nSubsample)
%	GIBBSSUMMARY - GibbsSummary(s,drop,vNames)
%	if s is a matrix, column names are given in "vNames"
%	is s is a structure, names are recovered
%	if drop<1, drop is interpreted as a PROPORTION of draws to drop;
%		otherwise, drop is the NUMBER of draws to drop.

if isstruct(s)
   [x, vNames] = StructToMatrix(s);
else
   x = s;
   if nargin<3
	   m = size(x,2);
   	vNames = cell(m,1);
	   for i=1:m
   	   vNames{i}=['Parameter ' int2str(i)];
      end
   end
end

if nargin<4
   nSubsample = 0;
end

[n,m] = size(x);
if drop>1
   ndrop = drop;
else
   ndrop = floor(drop*n);
end

nuse = n-ndrop;
y=x(ndrop+1:end,:);

z=fft(y,[],1);
Ixx = z.*conj(z);
mw=ceil( min(nuse/4,10*nuse^(1/5)));
avg=mean(Ixx(2:mw+1,:),1);
spectral_sem=sqrt(avg/(nuse*nuse));

s=std(y,1,1);
sem=s/sqrt(nuse);
s = [mean(y,1);median(y,1);s;sem;spectral_sem;min(y,[],1);max(y,[],1)]';

fprintf(1,'Gibbs Summary Statistics.  N Used=%g\n',nuse);
ColNames={'Mean' 'Median' 'Std.Dev.' 'SEM' 'Spectral SEM' 'Minimum' 'Maximum'};
PrintMatrix(s,vNames,ColNames);

if n>=1000 & nSubsample>0
	disp([' ',' ',' ']);
	disp('Subsample analyses:');
	pDrop = .2;
   SubSamp = zeros(m,9,nSubsample);
   kStart = floor( ( (0:(nSubsample-1))+pDrop )*n/nSubsample) + 1;
   kEnd = min(n, ceil((1:nSubsample)*n/nSubsample));
   for i=1:nSubsample
      %disp(['Subsampling draws ' int2str(kStart(i)) ' to ' int2str(kEnd(i)) '.']);
      nuse = kEnd(i) - kStart(i) + 1;
      y = x(kStart(i):kEnd(i),:);
		s = std(y,1,1);
      sem = s/sqrt(nuse);
      spectral_sem = repmat(NaN,size(sem));
      SubSamp(:,:,i) = [repmat(kStart(i),m,1), repmat(kEnd(i),m,1), ...
            [min(y,[],1); max(y,[],1); mean(y,1); median(y,1); s; sem;spectral_sem]'];
   end
   S = ipermute(SubSamp,[3 2 1]);
   for i=1:m
      disp(' ');
      disp(['Subsample results for parameter: ' char(vNames(i))]);
      ColNames={'Start' 'Finish' 'Minimum' 'Maximum' 'Mean' 'Median' 'Std.Dev.' 'SEM' 'Spectral SEM'};
      PrintMatrix(S(:,:,i),0,ColNames);
   end
end
